    /*
    
    ECU Experiment
    Reads inputs, performs some code simulating controlling an injector
    
    Analog Inputs (Max 6, all 0-5V input range)
    A0  TPS           -Rotary pot, read from wiper
    A1  RPM           -change to MAP/MAF/baro and derive RPM from pickup interval?
    A2  SystemV       -voltage divider, perhaps input protection required also
    A2  IAT           +5V source, fixed resistor, AI tap, out to sensor, return ground
    A3  CTS           +5V source, fixed resistor, AI tap, out to sensor, return ground         
    A4  O2
    
    
    Digital Inputs  (Max 14 DI/O, 12 if RX and TX are used)
    1  Cam Sensor   (Pick up from existing cam signal for coil activation)
    2  Crank Sensor (maybe not required for CFI fuel injection?)
    3  Idle stop switch?
    4  Cranking sense
    
    Digital Outputs
    1  Injector Trigger 1, to circuit driver, perhaps JBPerf PCB
    2  Injector Trigger 2
    3  Idle Up
    4  Idle Down
    5  Fuel pump relay  trigger relay for prime and also when cam signal or cranking signal is present?
    6  CEL LED?
    7  EGR activation
    8  Vapor canister activation
    
    
     */
  
  // Constants
  const int TPSIn = A0;  // Analog input pin that the potentiometer is attached to
  const int RPMIn = A1;
  const int SystemVIn = A2;  //Assume 4:1 voltage divider for now, so multiply reading by 5 to get actual voltage
  
  const float fuelmap [25] = { 20,30,40,50,60,   70,80,90,100,110,   120,130,140,155,160,   170,180,205,140,210,   220,230,240,250,260};  
                                                                        //25 cell map for testing
                                                                        //Sample values will eventually represent injector on times for each operating cell
 
  
  const int Rows = 5;          //Constant number of rows  and columns in fuel map. Creating as constant should make fuel map resizing easier in the future
  const int Columns = 5;       
  
 
 
 
  
  // Variables
  float BottomInterpolate = 0;      //Calculated value between Bottomleftcell and cell to the right in the same row
  float TopInterpolate = 0;         //Calculated value between cell above Bottomleftcell and cell to the right in the same row
  float MiddleInterpolate = 0;      //Interpolation between Bottom and TopInterpolate, single vertical interpolation between current row and row+1
  
  int TPSValue = 0;            //Value read from the pot
  int TPSColumn = 0;           //Calculated current column of Bottomleftcell of fuelmap
  int RPMValue = 0;            //Value read from the RPM pot, may be calculated from pulses in the future
  int RPMRow = 0;              //Calculated current row of Bottomleftcell of fuelmap
  
  float TPSModulus = 0;        //remainder of fuelmap cell finding process, used for interpolation
  float RPMModulus = 0;        //remainder of fuelmap cell finding process, used for interpolation
  float Fuelontime = 0;        //Final time to keep injector on, sum of Bottomleftcell and the interpolation process. In future will include other modifiers also
  
  int Bottomleftcell = 0;      //Calculated bottom left cell of the 4 cells to use for fuelmap lookup. Single 1D array used as pseudo 2D array
  
  /* Position numbers
  20  21  22  23  24
  15  16  17  18  19
  10  11  12  13  14          Bottomleftcell should never be 4, 9, 14, 19, or 20-24
   5   6   7   8   9
   0   1   2   3   4 
  */ 
  
  float SystemV = 0;  
  float SystemVTenths = 0;
  
  
  
  
  
  //Currently unimplemented variables
  int CamPositiveEdges = 0;    //Count positive edges from cam sensor, determine RPM from timer interval
  long OnCounter = 0;          //Counts how long ECU is on
  long RunningCounter = 0;     //Counts how long engine has been running
  
  int CurrentMode = 0;
    /* Definitions, perhaps implement in state machine
    On, waiting,
    Cranking/spinning, no sync
    Cranking/spinning, sync
    Shutdown
    
    
    */
  
  
  void setup() {
    // initialize serial communications at 9600 bps:
    Serial.begin(9600);
  }
  
  void loop() {
  // Read analog input to TPS, calculate column and modulus for later interpolation
  TPSValue = analogRead(TPSIn);
  TPSColumn = TPSValue / 256;
  TPSModulus = TPSValue % 256;
  
  // Read analog input for RPM, calculate row and modulus for later interpolation
  RPMValue = analogRead(RPMIn);
  RPMRow = RPMValue / 256;
  RPMModulus = RPMValue % 256;
 
  Bottomleftcell = ( RPMRow * Rows) + TPSColumn;        //Calculates Bottomleftcell
  
  BottomInterpolate =  ( TPSModulus / 256 ) * ( fuelmap [Bottomleftcell + 1] - fuelmap [Bottomleftcell] );                //Interpolates between bottom 2 cells
  TopInterpolate = (TPSModulus / 256 ) * (fuelmap [Bottomleftcell + 1 + Columns] - fuelmap [Bottomleftcell + Columns] );  //Interpolates between top 2 cells
  MiddleInterpolate = (RPMModulus / 256) * (TopInterpolate - BottomInterpolate);                                          //Interpolates vertically between Top and Bottom Interpolations
  
  Fuelontime = fuelmap [Bottomleftcell] + MiddleInterpolate;      //Add interpolated adjustment to bottom left cell value

  
  
  
  SystemV = analogRead(SystemVIn) ;           //Read SystemV channel 
  SystemVTenths = SystemV * 2000 / 1023;      //Max voltage is 20, with 4:1 input voltage divider settings. Protect with zener diode?
  
  
  

  // print the results to the serial monitor, adding parameters for testing, will likely change to different list and format for regular use
  Serial.print(TPSColumn);
  Serial.print(" ");
  Serial.print(RPMRow);
  Serial.print(" ");
  Serial.print(Bottomleftcell);
  Serial.print(" ");
  Serial.print(fuelmap [Bottomleftcell]);
  Serial.print(" ");
  Serial.print(TPSModulus);
  Serial.print(" ");
  Serial.print(RPMModulus);
  Serial.print(" ");
  Serial.print(BottomInterpolate);
  Serial.print(" ");
  Serial.print(TopInterpolate);
  Serial.print(" ");
  Serial.print(Fuelontime);
  Serial.print(" ");
  Serial.print(SystemVTenths);
  Serial.println(" ");
  //Serial.println(RPMValue);


  delay(200);      //Delay for testing
}
